﻿var actionEditor = {
    container: null,
    questionId: 0,
    actionId: 0,
    actionType: "",
    actionTypeText: "",
    autoSave: false,
    isNew: true,
    isPostAnswer: true,
    isPanelEventsBinded: false,

    panels: null,
    attributes: null
};


a4.top().$(document).ready(function () {
    a4.top().initDocument(document);
});

$(document).ready(function () {
    actionEditor.container = $(".v-actionContent");
    actionEditor.questionId = $("#QuestionId").val();
    actionEditor.actionId = $("#currentActionId").val();
    actionEditor.actionType = $("#currentActionType").val();
    actionEditor.autoSave = ($("#AutoSave").val().toLowerCase() == "true");
    actionEditor.isNew = ($("#NewAction").val().toLowerCase() == "true");
    actionEditor.isPostAnswer = ($("#IsPostAnswer").val().toLowerCase() == "true");

    setUIEvents();
    initializeEdition();
    $(".v-variable:visible").trigger("focus");  // Bug in IE
});

function initializeEdition() {
    if (actionEditor.actionType == "BranchTo" || actionEditor.actionType == "ExitSurvey") {
        setBranchToAutocomplete();
        a4.top().a4logicEditor.initializeSimpleLogic($(".v-branchSimpleLogic", actionEditor.container));
        actionEditor.actionTypeText = $("input[name='actionType']:checked", actionEditor.container).attr("data-displayText");
    }
    else {
        actionEditor.actionTypeText = $(".v-actionAction option:selected", actionEditor.container).attr("data-displayText");
        actionEditor.isPanelEventsBinded = false;
        setAdvanceLogicEvents();
    }

    initLogicEditor(actionEditor.questionId);

    if (executeSQLActionResultEditor && executeSQLActionResultEditor.context.length > 0) {
        executeSQLActionResultEditor.initialize();
        executeSQLActionResultEditor.bindEvents();
    }

    $(".v-variablePiping").a4richTextEditor({ fullToolbar: false, piping: true, piping_system: true, inline: true, multiLine: false });
    $(".v-questionnaireVariablePiping:not(.v-pointsReward)").a4richTextEditor({ fullToolbar: false, piping: true, piping_system: true, inline: true, multiLine: false });
    $(".v-pointsReward").a4richTextEditor({ fullToolbar: false, piping: true, piping_system: true, inline: true, multiLine: false, keydown: function (e) { a4.validateNumberKeyCode(e, true, $(".v-pointsReward").a4richTextEditor("getContent")); } });

    $("#BodyTextArea").a4richTextEditor({ library: true, piping: true, piping_system: true, inline: true, minHeight: 220 });
}

// Make sure all ajax calls for loading choices have completed
function initLogicEditor(questionId) {
    if (a4.top().a4.ajaxPendingCalls > 0) {
        setTimeout(function () { initLogicEditor(questionId); }, 100);
        return false;
    }
    else {
        // No longer prevent using the current question variables in the action edition
        //var question = $("#blockItemPanel" + questionId, a4.top().questionnaireEditor.container);
        a4.top().a4logicEditor.setVariableAutoComplete($(".v-executionConditionSection", document));
    }
}

function setBranchToAutocomplete() {
    $(".v-branchDestination", document).a4autocomplete({
        data: a4.top().questionnaireEditor.getSortedQuestions(),
        valueProperty: "value",
        labelProperty: "name",
        tooltipProperty: "questionId",
        tooltipData: function (autocomplete, tooltip, questionId) {
            a4.getTooltipQuestionText(autocomplete, tooltip, a4.top().questionnaireEditor.Id, questionId);
        },
        validateSelection: false,
        select: function (event, ui) {
            var value = $(this).val();
            var branchType = $("#BranchTypeValue", $(this).closest(".v-actionItem"));
            var relative = (ui.item === undefined || ui.item.questionId === undefined);

            if (relative && (value.indexOf("+") == -1)) {
                value = "+" + value;
            }

            if ((relative && isNaN(value.substring(1)))) {
                $(this).val("");
            }
            else if (relative) {
                branchType.val("ForwardRelative");

                $(this).val(value.substring(1));
                $(this).attr("data-value", value);
            }
            else if (ui.item !== undefined) {
                var thisQuestion = a4.top().questionnaireEditor.getQuestionById(actionEditor.questionId);
                var branchQuestion = a4.top().questionnaireEditor.getQuestionById(ui.item.value);
                var branchTypeValue = (thisQuestion.questionId == branchQuestion.questionId || a4.top().questionnaireEditor.sortQuestions(thisQuestion, branchQuestion) == 1) ? "BackwardAbsolute" : "ForwardAbsolute";
                branchType.val(branchTypeValue);
            }
        }
    });
}

function setActionHelpLink() {
    var editor = $(".modernEditor");

    if (editor.length > 0) {
        var anchor = $(".titleHelp a", editor);
        var ref = anchor.attr("href");

        var newRef = "";

        if (actionEditor.actionType == "BranchTo" || actionEditor.actionType == "ExitSurvey") {
            newRef = ref.substring(0, ref.indexOf("#")) + "#cshid=branch_rules";
        }
        else {
            var selection = $(".v-actionAction").find("option:selected");
            var helpName = selection.attr("data-help");
            newRef = ref.substring(0, ref.indexOf("#")) + (helpName ? "#cshid=" + helpName : "#cshid=advanced_logic");
        }

        //anchor.attr("href", newRef);
    }
}


function setUIEvents() {
    var content = $(document);

    //setActionHelpLink();

    content.on("change", "input[name='v-actionConditionType']", function () {
        var conditions = $(this).closest(".v-conditionContent");
        var inLogic = $(".v-executionConditionSection:visible", conditions).length > 0;

        $(".v-conditionItem", conditions).toggle();

        if (inLogic) {
            a4.top().a4logicEditor.initializeSimpleLogic($(".v-branchSimpleLogic", actionEditor.container));
        }
    });

    content.on("change", "input[name='actionType']", function () {
        var actions = $(this).closest(".v-actionSection");
        actionEditor.actionType = $(this).val();
        actionEditor.actionTypeText = $(this).attr("data-displayText");
        $(".v-actionItem", actions).toggle();
    });

    content.on("change", ".v-actionAction", function () {
        var content = $(this).closest(".v-actionContent");
        var selection = $(this).find("option:selected");
        actionEditor.actionType = selection.val();
        actionEditor.actionTypeText = selection.attr("data-displayText");

        $(".v-actionSection", content).hide();
        $("." + selection.attr("data-section"), content).show();
        $(".v-executionConditionSection", content).toggle(actionEditor.actionType != "ComputeVariable");

        setActionHelpLink();

        // Check initialization of set panelist data, or create action
        checkPanelistActions();
    });


    $("#submit").on("click", function () {
        var actionType = $(".v-actionAction option:selected", actionEditor.container).val();
        var panelPasswordAttributes = _.find($(".v-actionItemSection"), function (item) {
            return $(item).find(".v-selectAttribute").val() == "Password" && $(item).find(".v-attributeValue").val().match(/^\[.+\]$/g);
        });

        if (actionType == "CreatePanelist" && panelPasswordAttributes) {
            modalDialog.showConfirmDialog(confirmPanelPasswordNotificationResources, function () {
                saveActionAdvancedLogic()
            }, 250, 500);
        }
        else {
            saveActionAdvancedLogic();
        }
    });

    $(document).on('click', '#storeResultVariablesExecUrl', function () {
        $("#storeResultToExecUrl").show();
        $("#storeResultVariablesExecUrl").hide();
    });

    $(".v-timeoutLimit").on("input change paste", function (event) {
        var timeoutLimit = $(event.target);
        var sanitizedText = timeoutLimit.val().replace(/[^0-9]+/g, "");
        timeoutLimit.val('');
        timeoutLimit.val(sanitizedText);
    });
}

function togglePasswordVisibilityExecUrl() {
    var input = $("#passwordWithToggleExecUrl");

    if (input.attr("type") === "password") {
        input.attr("type", "text");
    } else {
        input.attr("type", "password");
    }
}

function authenticationMethodChangedExecUrl(event) {
    var optionSelected = $(event).find("option:selected");
    if (optionSelected) {
        if (optionSelected.val().trim() === 'Basic') {
            $("#usernameDiv").removeClass("hidden");
            $("#passwordDiv").removeClass("hidden");
        } else {
            $("#usernameDiv").addClass("hidden");
            $("#passwordDiv").addClass("hidden");
        }

        if (optionSelected.val().trim() === 'ApiKey') {
            $("#apiKeyDiv").removeClass("hidden");
            $("#apiKeyValueDiv").removeClass("hidden");
            $("#apiKeyLocationDiv").removeClass("hidden");
        } else {
            $("#apiKeyDiv").addClass("hidden");
            $("#apiKeyValueDiv").addClass("hidden");
            $("#apiKeyLocationDiv").addClass("hidden");
        }
    }
}

function saveActionAdvancedLogic() {
    if (ValidateAction()) {
        var properties = $(".v-actionProperty:visible:not(.v-groupProperty)").map(function () { return actionPropertyObject($(this)); }).get();
        var logic = null;

        if (actionEditor.actionType == "BranchTo" || actionEditor.actionType == "ExitSurvey") {
            logic = ($("#conditionIsMet").is(":checked"))
                ? a4logicEditor.getExecutionCondition()
                : a4logicEditor.createBasicLogicObject($(".v-branchSimpleLogic"));
        }
        else {
            logic = a4logicEditor.getLogic($(".v-executionConditionSection", document), false); // already validated
        }

        if (actionEditor.autoSave) {
            UpdateComputeVariableNameSetting();
            properties = _.reject(properties, function (v) { return v.Name == "InitialCalculatedVariableName"; });
            a4.parent().questionnaireEditor.questionController.updateAction(actionEditor.questionId, actionEditor.actionId, actionEditor.actionType, properties, logic);
        }
        else {
            a4.parent().setActionItem(actionEditor.questionId, actionEditor.actionId, actionEditor.actionType, actionEditor.actionTypeText, properties, logic, GetDisplayCondition(), actionEditor.isNew, actionEditor.isPostAnswer);
        }
    }
}

function setAdvanceLogicEvents() {
    var content = $(document);

    // Autocomplete question (Set Loop Row and Set Variable Value)
    const variablesDataSource = a4.top().questionnaireEditor.variables.sort(a4.top().questionnaireEditor.sortVariables);
    generateAutoCompleteElement(".v-questionVariable", variablesDataSource.filter(x => !x.isSecuredTemporaryVariable));
    generateAutoCompleteElement(".v-securedTemporaryVariableFlag", variablesDataSource);

    // Compute variable
    content.on("keydown", ".v-variable", function (event) {
        validateVariableKeyCode(event, this);
    });

    // Binding change from 'keyup' to 'change' to prevent problem on using the 'home' button
    content.on("change", ".v-variable", function (event) {
        if ($(this).val() == "-") {
            $(this).val("");
        }
        else if (event.keyCode != 37 && event.keyCode != 39) {    // Don't replace content for arrows (issue in chrome)
            $(this).val($(this).val().toUpperCase());
        }
    });

    // Set loop Row
    $(".v-surveyBlock", content).a4autocomplete({
        data: a4.top().questionnaireEditor.getSortedBlocks(),
        valueProperty: "value",
        labelProperty: "name"
    });

    content.on("change", "input[name='v-loopType']", function () {
        var actionContent = $(this).closest(".v-actionSection");
        $(".v-loopTypeAbsolute", actionContent).toggle($(this).val() == "Absolute");
        $(".v-loopTypeVariable", actionContent).toggle($(this).val() != "Absolute");
    });

    // Set Variable Value
    content.on("change", ".v-variableValueType input", function () {
        var actionContent = $(this).closest(".v-actionSection");
        $(".v-variableValueTypeSection", actionContent).toggle();
    });

    // Set Panelist data
    checkPanelistActions();

    // Selection
    content.on("click", ".v-displaySelectionEditor", function () {
        modalDialog.showWindow(a4.getSurveyAction("SelectionActionEditor", "Questionnaire"), 580, 800);
    });

    // General
    content.on("keydown", ".v-validatePositiveInt", function (event) {
        var result = a4.validateNumberKeyCode(event, false, $(this).val(), 6);
    });

    content.on("change", ".v-validatePositiveInt", function (event) {
        var value = parseInt($(this).val(), 10);

        if (value > 0) {
            $(this).val(value);
        }
        else {
            $(this).val('');
        }
    });

    function generateAutoCompleteElement(selector, sourceFunction) {
        $(selector, content).a4autocomplete({
            data: sourceFunction,
            valueProperty: "value",
            labelProperty: "name",
            tooltipProperty: "questionId",
            tooltipData: function(autocomplete, tooltip, questionId) {
                a4.getTooltipQuestionText(autocomplete, tooltip, a4.top().questionnaireEditor.Id, questionId);
            }
        });
    }
}

function checkPanelistActions() {
    if (actionEditor.actionType == "SetPanelistData" || actionEditor.actionType == "CreatePanelist") {

        if (!actionEditor.isPanelEventsBinded) {
            var panelActionContainer = $(".v-usePanelData", actionEditor.container);//actionEditor.actionType == "SetPanelistData" ? $(".v-setPanelistDataControls", actionEditor.container) : $(".v-createPanelistControls", actionEditor.container)

            if (a4.top().questionnaireEditor.panels == null) {
                a4.top().questionnaireEditor.loadPanelData(function () { initializePanelData(panelActionContainer); });
            }
            else {
                initializePanelData(panelActionContainer);
            }
            actionEditor.isPanelEventsBinded = true;
        }
    }
}

function addRequiredAttributesRows(panelId, container, panelRequiredFields) {
    $(".v-attributesTable tbody tr.v-actionItemSection", container).remove();

    $.each($(a4.top().questionnaireEditor.getPanelRequiredAttributes(panelId, panelRequiredFields)), function (i, requiredAttribute) {
        var content = container.closest(".v-actionSection");
        var row = $($(".v-newAttribute tbody", content).html());
        var attrNameInput = $(".v-selectAttribute", row);
        attrNameInput.val(requiredAttribute.name);
        attrNameInput.attr("readonly", "readonly");

        $(".h-deleteRow", row).remove();

        $(".v-attributesTable tbody.v-attributesTableBody", content).show().append(row);
    });
}



function initializePanelData(panelActionContainer) {

    $(".v-selectPanel", panelActionContainer).a4autocomplete({
        data: a4.top().questionnaireEditor.panels,
        valueProperty: "value",
        labelProperty: "name",
        select: function (event, ui) {
            var enforceRequiredAttributes = $(this).hasClass("v-enforceRequiredAttributes");
            var container = $(this).closest(".v-usePanelData");
            var itemExist = (ui.item != undefined);
            $(".v-attributesTable", container).toggle(itemExist);
            $(".v-addAttributeButton", container).toggle(itemExist);

            if (!itemExist) {
                $(".v-attributesTable tbody tr.v-actionItemSection", container).remove();
            }
            else {
                if (enforceRequiredAttributes) {
                    var panel = a4.top().questionnaireEditor.getPanelById(ui.item.value);
                    addRequiredAttributesRows(ui.item.value, container, panel.requiredFields)
                }
                else {
                    $(".v-attributesTable tbody tr.v-actionItemSection", container).each(function () {
                        var row = $(this);
                        var attribute = a4.top().questionnaireEditor.getPanelAttributeByName($(".v-selectAttribute", row).val());

                        if (attribute != null && (attribute.panelId == 0 || attribute.panelId == ui.item.value)) {
                            row.show();
                            if (!attribute.isRequired) {
                                setPanelAttributeAutoComplete(row, ui.item.value, container.hasClass("v-createPanelistControls"));
                            }
                        }
                        else {
                            row.remove();
                        }
                    });
                }
            }
        }
    });

    $(".h-addAttributeRow", panelActionContainer).on("click", function (event) {
        event.stopPropagation();
        var content = $(this).closest(".v-actionSection");
        var panelId = $(".v-selectPanel", content).attr("data-value");

        var row = $($(".v-newAttribute tbody", content).html());
        var body = $(".v-attributesTable tbody.v-attributesTableBody", content);
        $(".h-deleteRow", row).on('click', function () { $(this).closest("tr").remove(); });
        body.show().append(row);

        setPanelAttributeAutoComplete($(".v-attributesTable tbody.v-attributesTableBody tr.v-actionItemSection:last", content), panelId, content.hasClass("v-createPanelistControls"))
    });

    $(".v-attributesTable .h-deleteRow", panelActionContainer).on('click', function () {
        $(this).closest("tr").remove();
    });

    var panelId = $(".v-selectPanel:visible", panelActionContainer).attr("data-value");

    if (panelId != "") {
        $(".v-attributesTable", panelActionContainer).show();
        $(".v-addAttributeButton", panelActionContainer).show();
        setPanelAttributeAutoComplete(panelActionContainer, panelId, panelActionContainer.hasClass("v-createPanelistControls"));
    }

    // Check attributes are still in use
    $(".v-selectAttribute", panelActionContainer).each(function () {
        if ($(this).val() != "") {
            $(this).trigger("change");
        }
    });
}

function setPanelAttributeAutoComplete(content, panelId, includeUserName) {
    var acAttributes = a4.top().questionnaireEditor.getPanelAttributes(parseInt(panelId));

    if (!includeUserName) acAttributes.shift(); // remove first one, which is username

    var actionType = $(".v-actionAction option:selected", actionEditor.container).val();
    if (actionType == "SetPanelistData") {
        acAttributes = _.reject(acAttributes, function (item) { return item.name == "Password"; });
    }

    $(".v-selectAttribute:not([readonly])", content).a4autocomplete({
        data: acAttributes,
        valueProperty: "name",
        labelProperty: "name",
    });
}

function getSelectionDefinition() {
    var action = $(".v-actionSection:visible");
    return $(".v-selectionDefinition", action).val();
}

function validateSelectionActions(JsonSelection) {
    a4.callServerMethod(a4.top().questionnaireEditor.getUrl("ValidateSelectionDefinition"), { definitionJson: JsonSelection },
        function () { updateSelectionActionFields(JsonSelection); },
        function (error) {
            a4.onAjaxPageMethodError(error);
        });
}


function updateSelectionActionFields(JsonSelection) {
    updateSelectionResume(JsonSelection);
    $(".v-selectionDefinition").val(JsonSelection);
    $.fancybox.close();
}


function updateSelectionResume(JsonSelection) {
    var selection = JSON.parse(JsonSelection);
    var varText = "";

    for (var i = 0; i < selection.Variables.length; i++) {
        varText += selection.Variables[i].VariableName;

        if (i + 1 != selection.Variables.length) {
            varText += ", ";
        }
    }

    var selectionContent = $(".v-selectionControls");
    $(".v-assignedVariablesText", selectionContent).html(varText);
    $(".v-selectionCountText", selectionContent).html(selection.Selections.length);
    $(".v-selectionCount", selectionContent).val(selection.Selections.length);
}

// ------------------------------ FUNCTIONS ---------------------------------


function GetDisplayCondition() {
    var result = "";
    var condition = "{executionCondition}";
    var getItemValue = a4.top().questionnaireEditor.getItemValue;

    switch (actionEditor.actionType) {
        case "BranchTo":
            result = condition + " " + actionEditor.actionTypeText + " " + getItemValue($(".v-branchDestination", actionEditor.container));
            break;

        case "ComputeVariable":
            result = getItemValue($(".v-variable:visible", actionEditor.container)) + " = " + a4.decodeHtml(getItemValue($(".v-variableValue:visible", actionEditor.container)));
            break;

        case "ExitSurvey":
            var url = getItemValue($(".v-actionProperty[data-name=ExitUrl]", actionEditor.container)).trim();
            if (url == "") {
                result = condition + " -> " + $(".v-exitSurveyStatus option:selected", actionEditor.container).text();
            }
            else {
                result = condition + " -> " + a4.decodeHtml(url) + " (" + $(".v-exitSurveyStatus option:selected", actionEditor.container).text() + ")";
            }
            break;

        case "PanelistReward":
            result = condition + " -> " + a4.top().questionnaireEditor.resources.PointsReward.replace("{0}", getItemValue($(".v-pointsReward:visible", actionEditor.container)));
            break;

        case "SendEmail":
            result = condition + " -> " + a4.top().questionnaireEditor.resources.EmailTo + " " + getItemValue($(".v-emailTo:visible", actionEditor.container));
            break;

        case "SetLoopRow":
            result = condition + " " + a4.top().questionnaireEditor.resources.LoopTo + " " + getItemValue($(".v-loopTypeValue:visible", actionEditor.container));
            break;

        case "SetVariableValue":
            var variable = getItemValue($(".v-questionVariable:visible", actionEditor.container));
            result = condition + " -> " + variable["name"] + " = " + getItemValue($(".v-variableValue:visible", actionEditor.container));
            break;

        case "Selection":
            result = condition + " -> " + $(".v-selectionCountText:visible", actionEditor.container).text() + a4.top().questionnaireEditor.resources.SelectionHasBeenDefined;
            break;
        // selectPanel

        case "SetPanelistData":
            var selectedPanel = getItemValue($(".v-selectPanel:visible", actionEditor.container));
            result = condition + " -> " + a4.top().questionnaireEditor.resources.SetPanelistDataDefinition.replace("{0}", selectedPanel["name"]);
            break;

        case "CreatePanelist":
            var selectedPanel = getItemValue($(".v-selectPanel:visible", actionEditor.container));
            result = condition + " -> " + a4.top().questionnaireEditor.resources.CreatePanelistDefinition.replace("{0}", selectedPanel["name"]);
            break;

        case "ResumeLastSession":
            result = condition;
            break;

        case "MobileAudioRecording":
            result = condition + " -> " + $("input[name='cv-modeType']:checked", actionEditor.container).attr("data-displayText");
            break;

        case "ExecUrl":
            var url = getItemValue($(".v-actionProperty[data-name=TargetUrl]", actionEditor.container)).trim();
            if (url) {
                result = a4.top().questionnaireEditor.resources.SendRequestTo + " " + a4.decodeHtml(url);
            }
            break;

        case "ParseTextVariable":
            var targetVariable = getItemValue($(".v-actionProperty[data-name=TargetVariableId]", actionEditor.container));
            var inputVariable = getItemValue($(".v-actionProperty[data-name=InputVariableId]", actionEditor.container));
            if (targetVariable && inputVariable) {
                result = a4.top().questionnaireEditor.resources.ParseTextVariableInto.replace("{0}", inputVariable.name)
                    .replace("{1}", targetVariable.name);
            }
            break;
    }

    return result;
}

function GetComputeVariableName() {
    return new Array($(".v-calculatedVariableOriginalName", actionEditor.container).val().toUpperCase(), $(".v-variable:visible", actionEditor.container).val().toUpperCase());
}

function UpdateComputeVariableNameSetting() {
    if (actionEditor.actionType == "ComputeVariable") {
        var computeVariableName = GetComputeVariableName();
        var itemBeforeEdit = _.find(a4.parent().questionnaireEditor.editComputeVariables, function (v) { return v.name.toUpperCase() == computeVariableName[0]; });
        var initialVariableName = (itemBeforeEdit) ? itemBeforeEdit.name : "";

        a4.top().questionnaireEditor.updateVariableList(initialVariableName, computeVariableName[1], actionEditor.questionId);
    }
}

function ValidateAction() {
    var valid = true, logicError = false;
    var errorMessage = "";
    var property, controls;

    // Validate required fields
    $(".v-requiredField:visible", actionEditor.container).each(function () {
        if (valid) {
            var fieldName = $(this).find(".v-fieldName").text();

            controls = $(this).find(".v-actionProperty:visible");

            controls.each(function () {
                var control = $(this);

                property = a4.getInputValue(control);

                if (property != undefined && String(property).trim() == "") {
                    errorMessage = a4.top().questionnaireEditor.resources.ErrorFieldIsRequired.replace("{0}", fieldName);
                    valid = false;
                }
            });
        }
    });

    // If all required fields were entered then validate fields content    
    if (valid) {
        $(".v-actionProperty:visible", actionEditor.container).each(function () {
            if (valid) {
                var itemValue = a4.getInputValue($(this));
                var itemLabel = $(this).parent().prev(".v-fieldName").text();

                if (itemValue != "") {
                    if ($(this).hasClass("v-emailAddress")) {
                        if (!isEmail(itemValue)) {
                            errorMessage = a4.top().questionnaireEditor.resources.ErrorEmailAddressInvalid.replace("{0}", itemLabel);
                            valid = false;
                        }
                    }
                    else if ($(this).hasClass("v-emailAddressList")) {
                        if (!validEmailList(itemValue)) {
                            errorMessage = a4.top().questionnaireEditor.resources.ErrorEmailListInvalid.replace("{0}", itemLabel);
                            valid = false;
                        }
                    }
                    else if ($(this).hasClass("v-url")) {
                        if (!isURL(itemValue) && !itemValue.startsWith("[")) {
                            errorMessage = a4.top().questionnaireEditor.resources.ErrorUrlIsInvalid.replace("{0}", itemLabel);
                            valid = false;
                        }
                    }
                    else if ($(this).hasClass("v-timeoutLimit")) {
                        if (itemValue < 1 || itemValue > 60) {
                            errorMessage = a4.top().questionnaireEditor.resources.ErrorMessageRequestTimeout;
                            valid = false;
                        }
                    }
                }
            }
        });
    }

    if (valid) {
        valid = a4logicEditor.validateExecutionCondition();
        logicError = !valid;
    }

    if (valid) {
        // Validate the compute variable - variable name is unique
        if (actionEditor.actionType == "ComputeVariable") {
            var computeVariableName = GetComputeVariableName();
            var existingVariable = a4.top().questionnaireEditor.getVariableByName(computeVariableName[1]);

            if (computeVariableName[0] != computeVariableName[1] && existingVariable) {
                errorMessage = a4.top().questionnaireEditor.resources.ErrorDuplicateVariableNames.replace("{0}", computeVariableName[1]);
                valid = false;
            }
            else {
                var re = /^[a-zA-Z_]+[0-9a-zA-Z_]*$/;
                if (!re.test(computeVariableName[1])) {
                    errorMessage = a4.top().questionnaireEditor.resources.ErrorVariableInvalidSyntax.replace("{0}", computeVariableName[1]);
                    valid = false;
                }
            }
        }
        // Validate set panelist data
        else if (actionEditor.actionType == "SetPanelistData" || actionEditor.actionType == "CreatePanelist") {
            if ($(".v-attributesTable tbody tr", actionEditor.container).length == 0) {
                errorMessage = a4.top().questionnaireEditor.resources.ErrorMessage_SetPanelistActionNoAttribute;
                valid = false;
            }
            else {
                $(".v-attributesTable tbody tr", actionEditor.container).each(function (idx, row) {
                    if (($(".v-selectAttribute", row).val() == "" || ($(".v-attributeValue", row).val() == "" && $(".v-attributeConditionType", row).is(":checked")))
                        || $(".v-attributeValue", row).val().length == 0) {
                        errorMessage = a4.top().questionnaireEditor.resources.ErrorMessage_SetPanelistActionMissingAttribute;
                        valid = false;
                        return;
                    }
                });
            }

            if (valid) {
                setPanelistDataDefinitionObject();
            }
        }
    }

    // Show error message before exiting loop
    if (!valid && !logicError) {
        a4.showErrorMessage(errorMessage);
    }

    return valid;
}


function setPanelistDataDefinitionObject() {
    var panelistDataDef = new Object();
    panelistDataDef.PanelistDatas = [];

    $(".v-attributesTable tbody tr", actionEditor.container).each(function () {
        var dataItem = newPanelistData($(this));
        panelistDataDef.PanelistDatas.push(dataItem);
    });

    $(".v-jsonDefinition", actionEditor.container).val(JSON.stringify(panelistDataDef));
}

function newPanelistData(row) {
    var dataDef = new Object();
    dataDef.AttributeName = $(".v-selectAttribute", row).val();
    dataDef.ValueType = $(".v-attributeConditionType", row).is(":checked") ? "2" : "0";   // 2 is Formula
    dataDef.Value = $(".v-attributeValue", row).val();
    return dataDef;
}


function validEmailList(value) {
    var emailList = value.split(";");
    var validList = true;

    for (i = 0; i < emailList.length && validList; i++) {
        if (emailList[i] != "") {
            validList = (isEmail(emailList[i].trim()));
        }
    }

    return validList;
}

function isEmail(email) {
    var emailPattern = /^[a-zA-Z0-9._-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,4}$/;
    var recallPattern = /^\[([a-zA-Z0-9._$]+)(\([a-zA-Z0-9._-]+\))*\]$/;
    return recallPattern.test(email) || emailPattern.test(email);
}

function isURL(url) {
    var urlPattern = /^(((ht|f)tp(s?):\/\/)|(www\.[^ \[\]\{\}\(\)\n\r\t]+)|(([012]?[0-9]{1,2}\.){3}[012]?[0-9]{1,2})\/)([^ \{\}\(\),;'<>\n\r\t]+)([^. \{\}\(\),;'<>\n\r\t])|(([012]?[0-9]{1,2}\.){3}[012]?[0-9]{1,2})/i;
    return urlPattern.test(url);
}

function validateVariableKeyCode(_event, _element, _value, _maxLength) {
    var _valid = true;
    var _isFirstChar = ($(_element).val().length == 0);

    // Allow only backspace and delete, left right arrows or a starting _ and -
    //  Note that the equal sign has the same keycode as the plus - we delete the equal in the keyup function
    if (_event.keyCode == 46 || _event.keyCode == 8 || _event.keyCode == 37 || _event.keyCode == 39) {
        // let it happen, don't do anything
    }
    else if (_event.keyCode == 32
        || (_isFirstChar && (_event.keyCode < 65 || (90 < _event.keyCode && _event.keyCode != 109)))) {
        _event.preventDefault();
        _valid = false;
    }

    return _valid;
}

//--------------------------- Object ---------------------------

function actionPropertyObject(property) {
    var actionProperty = new Object();
    actionProperty.Name = property.attr("data-name")

    if (property.is("span")) {
        actionProperty.Value = property.children("input:checkbox").is(":checked");
    }
    else if (property.is(":checkbox")) {
        actionProperty.Value = property.is(":checked");
    }
    else if (property.find("input:radio").length > 0) {
        actionProperty.Value = property.find("input:checked").val();
    }
    else if (
        property.hasClass("v-branchDestination") || property.hasClass("v-questionQuestion") ||
        property.hasClass("v-surveyBlock") || property.hasClass("v-selectPanel") ||
        ((property.hasClass("v-questionVariable") || property.hasClass("v-securedTemporaryVariableFlag")) && !property.hasClass("v-useVariableName"))
    )
    {
        actionProperty.Value = property.attr("data-value");
    }
    else if ((property.hasClass("v-questionVariable") || property.hasClass("v-securedTemporaryVariableFlag")) && property.hasClass("v-useVariableName")) {
        actionProperty.Value = "[" + property.val() + "]"; // we add bracket because we want it to be executed as a recall
    }
    else if (property.hasClass("rich-text-editor")) {
        actionProperty.Value = property.a4richTextEditor("getContent");
    }
    else if (property.hasClass("v-executeSQLResultMapping")) {
        actionProperty.Value = getExecuteSQLResultMapping(property);
    }
    else {
        actionProperty.Value = property.val().trim();
    }

    return actionProperty;
}

function getExecuteSQLResultMapping(property) {
    var actionProperty = new Object();
    actionProperty["Mapping"] = $(".v-conditionRow", property).map(function (index, conditionRow) {
        var innerProperty = new Object();
        innerProperty["VariableName"] = $(".v-executeSQLVariableId", conditionRow).val();
        innerProperty["ResultName"] = $(".v-executeSQLResultName", conditionRow).val();
        innerProperty["Index"] = $(".v-executeSQLIndex", conditionRow).val();
        return innerProperty;
    }).get();
    return actionProperty;
}